﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Linq" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">

    protected void LinqDataSource1_Deleting
        (object sender, LinqDataSourceDeleteEventArgs e)
    {
        NWDataClassesDataContext dc = new NWDataClassesDataContext();
        Product prod;
        prod = (Product)e.OriginalObject;
        var q = from o in dc.Order_Details
                where o.ProductID == prod.ProductID
                select o;
        foreach (Order_Detail od in q)
        {
            dc.Order_Details.DeleteOnSubmit(od);
        }
        dc.SubmitChanges();
    }


    protected void ListView1_ItemCreated(object sender, ListViewItemEventArgs e)
    {
        ListViewItem li;
        DropDownList ddl;
        if (e.Item.ItemType == ListViewItemType.InsertItem)
        {
            li = e.Item;
            ddl = (DropDownList)li.FindControl("SupplierIDDDL");
            if (ddl != null)
            {
                NWDataClassesDataContext dc = new NWDataClassesDataContext();
                var q = from c in dc.Suppliers
                        orderby c.CompanyName
                        select c;
                ListItem itm;
                ddl.Items.Clear();
                foreach (Supplier i in q)
                {
                    itm = new ListItem();
                    itm.Text = i.CompanyName;
                    itm.Value = Convert.ToString(i.SupplierID);
                    ddl.Items.Add(itm);
                }
            }
        }
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Untitled Page</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:DropDownList ID="ddlFilter" runat="server" AutoPostBack="True" 
            DataSourceID="LinqCategoryDs" DataTextField="CategoryName" 
            DataValueField="CategoryID">
        </asp:DropDownList>
        <br />
        <asp:ListView ID="ListView1" runat="server" DataKeyNames="ProductID" DataSourceID="LinqDataSource1"
            InsertItemPosition="LastItem" OnItemCreated="ListView1_ItemCreated">
            <AlternatingItemTemplate>
                <tr style="background-color: #FFF8DC;">
                    <td>
                        <asp:Button ID="DeleteButton" runat="server" CommandName="Delete" Text="Delete" OnClientClick="return confirm('Do you really want to remove this product and all references to it in the Order Details Table?');" />
                        <asp:Button ID="EditButton" runat="server" CommandName="Edit" Text="Edit" />
                    </td>
                    <td>
                        <asp:Label ID="ProductIDLabel" runat="server" Text='<%# Eval("ProductID") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ProductNameLabel" runat="server" Text='<%# Eval("ProductName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="SupplierIDLabel" runat="server" Text='<%# Eval("Supplier.CompanyName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="CategoryIDLabel" runat="server" Text='<%# Eval("Category.CategoryName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="QuantityPerUnitLabel" runat="server" Text='<%# Eval("QuantityPerUnit") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitPriceLabel" runat="server" Text='<%# Eval("UnitPrice") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsInStockLabel" runat="server" Text='<%# Eval("UnitsInStock") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsOnOrderLabel" runat="server" Text='<%# Eval("UnitsOnOrder") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ReorderLevelLabel" runat="server" Text='<%# Eval("ReorderLevel") %>' />
                    </td>
                    <td>
                        <asp:CheckBox ID="DiscontinuedCheckBox" runat="server" Checked='<%# Eval("Discontinued") %>'
                            Enabled="false" />
                    </td>
                </tr>
            </AlternatingItemTemplate>
            <LayoutTemplate>
                <table runat="server">
                    <tr runat="server">
                        <td runat="server">
                            <table id="itemPlaceholderContainer" runat="server" border="1" style="background-color: #FFFFFF;
                                border-collapse: collapse; border-color: #999999; border-style: none; border-width: 1px;
                                font-family: Verdana, Arial, Helvetica, sans-serif;">
                                <tr runat="server" style="background-color: #DCDCDC; color: #000000;">
                                    <th runat="server">
                                    </th>
                                    <th runat="server">
                                        ProductID
                                    </th>
                                    <th runat="server">
                                        ProductName
                                    </th>
                                    <th runat="server">
                                        SupplierID
                                    </th>
                                    <th runat="server">
                                        CategoryID
                                    </th>
                                    <th runat="server">
                                        QuantityPerUnit
                                    </th>
                                    <th runat="server">
                                        UnitPrice
                                    </th>
                                    <th runat="server">
                                        UnitsInStock
                                    </th>
                                    <th runat="server">
                                        UnitsOnOrder
                                    </th>
                                    <th runat="server">
                                        ReorderLevel
                                    </th>
                                    <th runat="server">
                                        Discontinued
                                    </th>
                                </tr>
                                <tr id="itemPlaceholder" runat="server">
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr runat="server">
                        <td runat="server" style="text-align: center; background-color: #CCCCCC; font-family: Verdana, Arial, Helvetica, sans-serif;
                            color: #000000;">
                            <asp:DataPager ID="DataPager1" runat="server">
                                <Fields>
                                    <asp:NextPreviousPagerField ButtonType="Button" ShowFirstPageButton="True" ShowLastPageButton="True" />
                                </Fields>
                            </asp:DataPager>
                        </td>
                    </tr>
                </table>
            </LayoutTemplate>
            <InsertItemTemplate>
                <tr style="">
                    <td>
                        <asp:Button ID="InsertButton" runat="server" CommandName="Insert" Text="Insert" />
                        <asp:Button ID="CancelButton" runat="server" CommandName="Cancel" Text="Clear" />
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td>
                        <asp:TextBox ID="ProductNameTextBox" runat="server" Text='<%# Bind("ProductName") %>' />
                    </td>
                    <td>
                        <asp:DropDownList ID="SupplierIDDDL" runat="server" SelectedValue='<%# Bind("SupplierID") %>'>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:TextBox ID="CategoryIDTextBox" runat="server" Text='<%# Bind("CategoryID") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="QuantityPerUnitTextBox" runat="server" Text='<%# Bind("QuantityPerUnit") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitPriceTextBox" runat="server" Text='<%# Bind("UnitPrice") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitsInStockTextBox" runat="server" Text='<%# Bind("UnitsInStock") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitsOnOrderTextBox" runat="server" Text='<%# Bind("UnitsOnOrder") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="ReorderLevelTextBox" runat="server" Text='<%# Bind("ReorderLevel") %>' />
                    </td>
                    <td>
                        <asp:CheckBox ID="DiscontinuedCheckBox" runat="server" Checked='<%# Bind("Discontinued") %>' />
                    </td>
                </tr>
            </InsertItemTemplate>
            <SelectedItemTemplate>
                <tr style="background-color: #008A8C; font-weight: bold; color: #FFFFFF;">
                    <td>
                        <asp:Button ID="DeleteButton" runat="server" CommandName="Delete" Text="Delete" OnClientClick="return confirm('Do you really want to remove this product and all references to it in the Order Details Table?');" />
                        <asp:Button ID="EditButton" runat="server" CommandName="Edit" Text="Edit" />
                    </td>
                    <td>
                        <asp:Label ID="ProductIDLabel" runat="server" Text='<%# Eval("ProductID") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ProductNameLabel" runat="server" Text='<%# Eval("ProductName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="SupplierIDLabel" runat="server" Text='<%# Eval("Supplier.CompanyName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="CategoryIDLabel" runat="server" Text='<%# Eval("Category.CategoryName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="QuantityPerUnitLabel" runat="server" Text='<%# Eval("QuantityPerUnit") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitPriceLabel" runat="server" Text='<%# Eval("UnitPrice") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsInStockLabel" runat="server" Text='<%# Eval("UnitsInStock") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsOnOrderLabel" runat="server" Text='<%# Eval("UnitsOnOrder") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ReorderLevelLabel" runat="server" Text='<%# Eval("ReorderLevel") %>' />
                    </td>
                    <td>
                        <asp:CheckBox ID="DiscontinuedCheckBox" runat="server" Checked='<%# Eval("Discontinued") %>'
                            Enabled="false" />
                    </td>
                </tr>
            </SelectedItemTemplate>
            <EmptyDataTemplate>
                <table runat="server" style="background-color: #FFFFFF; border-collapse: collapse;
                    border-color: #999999; border-style: none; border-width: 1px;">
                    <tr>
                        <td>
                            No data was returned.
                        </td>
                    </tr>
                </table>
            </EmptyDataTemplate>
            <EditItemTemplate>
                <tr style="background-color: #008A8C; color: #FFFFFF;">
                    <td>
                        <asp:Button ID="UpdateButton" runat="server" CommandName="Update" Text="Update" />
                        <asp:Button ID="CancelButton" runat="server" CommandName="Cancel" Text="Cancel" />
                    </td>
                    <td>
                        <asp:Label ID="ProductIDLabel1" runat="server" Text='<%# Eval("ProductID") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="ProductNameTextBox" runat="server" Text='<%# Bind("ProductName") %>' />
                    </td>
                    <td>
                        <asp:DropDownList ID="SupplierIDDropDownList" runat="server" DataSourceID="LinqSupplierDS"
                            DataValueField="SupplierID" DataTextField="CompanyName" SelectedValue='<%# Bind("SupplierID") %>'>
                        </asp:DropDownList>
                    </td>
                    <td>
                        <asp:TextBox ID="CategoryIDTextBox" runat="server" Text='<%# Bind("CategoryID") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="QuantityPerUnitTextBox" runat="server" Text='<%# Bind("QuantityPerUnit") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitPriceTextBox" runat="server" Text='<%# Bind("UnitPrice") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitsInStockTextBox" runat="server" Text='<%# Bind("UnitsInStock") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="UnitsOnOrderTextBox" runat="server" Text='<%# Bind("UnitsOnOrder") %>' />
                    </td>
                    <td>
                        <asp:TextBox ID="ReorderLevelTextBox" runat="server" Text='<%# Bind("ReorderLevel") %>' />
                    </td>
                    <td>
                        <asp:CheckBox ID="DiscontinuedCheckBox" runat="server" Checked='<%# Bind("Discontinued") %>' />
                    </td>
                </tr>
            </EditItemTemplate>
            <ItemTemplate>
                <tr style="background-color: #DCDCDC; color: #000000;">
                    <td>
                        <asp:Button ID="DeleteButton" runat="server" CommandName="Delete" Text="Delete" OnClientClick="return confirm('Do you really want to remove this product and all references to it in the Order Details Table?');" />
                        <asp:Button ID="EditButton" runat="server" CommandName="Edit" Text="Edit" />
                    </td>
                    <td>
                        <asp:Label ID="ProductIDLabel" runat="server" Text='<%# Eval("ProductID") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ProductNameLabel" runat="server" Text='<%# Eval("ProductName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="SupplierIDLabel" runat="server" Text='<%# Eval("Supplier.CompanyName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="CategoryIDLabel" runat="server" Text='<%# Eval("Category.CategoryName") %>' />
                    </td>
                    <td>
                        <asp:Label ID="QuantityPerUnitLabel" runat="server" Text='<%# Eval("QuantityPerUnit") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitPriceLabel" runat="server" Text='<%# Eval("UnitPrice") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsInStockLabel" runat="server" Text='<%# Eval("UnitsInStock") %>' />
                    </td>
                    <td>
                        <asp:Label ID="UnitsOnOrderLabel" runat="server" Text='<%# Eval("UnitsOnOrder") %>' />
                    </td>
                    <td>
                        <asp:Label ID="ReorderLevelLabel" runat="server" Text='<%# Eval("ReorderLevel") %>' />
                    </td>
                    <td>
                        <asp:CheckBox ID="DiscontinuedCheckBox" runat="server" Checked='<%# Eval("Discontinued") %>'
                            Enabled="false" />
                    </td>
                </tr>
            </ItemTemplate>
        </asp:ListView>
    </div>
    <asp:LinqDataSource ID="LinqDataSource1" runat="server" ContextTypeName="NWDataClassesDataContext"
        EnableDelete="True" EnableInsert="True" EnableUpdate="True" TableName="Products"
        OnDeleting="LinqDataSource1_Deleting" Where="CategoryID == @CategoryID">
        <WhereParameters>
            <asp:ControlParameter ControlID="ddlFilter" Name="CategoryID" 
                PropertyName="SelectedValue" Type="Int32" />
        </WhereParameters>
    </asp:LinqDataSource>
    <asp:LinqDataSource ID="LinqSupplierDS" runat="server" ContextTypeName="NWDataClassesDataContext"
        OrderBy="CompanyName" Select="new (SupplierID, CompanyName)" TableName="Suppliers">
    </asp:LinqDataSource>
    <asp:LinqDataSource ID="LinqCategoryDs" runat="server" 
        ContextTypeName="NWDataClassesDataContext" OrderBy="CategoryName" 
        TableName="Categories">
    </asp:LinqDataSource>
    </form>
</body>
</html>
