﻿<%@ Page Language="C#" Debug="true" %>
<%@ Import Namespace="System.Linq" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">

    protected void Page_Load(object sender, EventArgs e)
    {
        NWDataClassesDataContext dc = new NWDataClassesDataContext();
        var q = (from c in dc.Categories
                 from p in dc.Products
                 where c.CategoryID == p.CategoryID
                 group p by c.CategoryName into g
                 let CategoryName = g.Key
                 let Group = g.ToArray()
                 select new { CategoryName, Group }).Select(s =>
                     new { cgname = s.CategoryName, prdcts = s.Group });

        gvCategories.DataSource = q;
        gvCategories.DataBind();
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Untitled Page</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:GridView ID="gvCategories" runat="server" AutoGenerateColumns="False">
            <Columns>
                <asp:TemplateField ShowHeader="False">
                    <ItemTemplate>
                        <asp:Label ID="Label1" runat="server" Text='<%# Eval("cgname") %>'></asp:Label>
                        <br />
                        <asp:GridView ID="GridView1" runat="server" DataSource='<%# Eval("prdcts") %>'>
                        </asp:GridView>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
    </div>
    </form>
</body>
</html>
