﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Linq" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">

    protected void Page_Load(object sender, EventArgs e)
    {
        BindData();
    }

    protected void BindData()
    {
        NWDataClassesDataContext dc = new NWDataClassesDataContext();
        var q = from p in dc.Products select p;
        GridView1.DataSource = q;
        GridView1.DataBind();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        NWDataClassesDataContext dc = new NWDataClassesDataContext();
        var q = from p in dc.Products
                where p.ProductName.StartsWith("c")
                select p;
        foreach (Product prod in q)
        {
            prod.ProductName = prod.ProductName.ToExclaim();
            
            // To remove the exclamation marks use the following
            // string find = "!";
            // string replace = string.Empty;
            // prod.ProductName = System.Text.RegularExpressions.Regex.Replace(prod.ProductName, find, replace);
        }
        dc.SubmitChanges();
        BindData();
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        NWDataClassesDataContext dc = new NWDataClassesDataContext();
        Product prod = new Product();
        prod.ProductName = "CoolJuice";
        prod.QuantityPerUnit = "8 per box";
        prod.UnitPrice = 5;
        prod.SupplierID = 2;
        prod.CategoryID = 1;
        prod.UnitsInStock = 5;
        prod.ReorderLevel = 1;
        dc.Products.InsertOnSubmit(prod);
        dc.SubmitChanges();
        BindData();
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Extension method</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:Button ID="Button1" runat="server" Text="Button" OnClick="Button1_Click" />
        &nbsp;<asp:Button ID="Button2" runat="server" onclick="Button2_Click" 
            Text="Insert" />
        <br />
        <br />
        <asp:GridView ID="GridView1" runat="server">
        </asp:GridView>
    </div>
    </form>
</body>
</html>
