﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Linq" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">

    protected void Page_Load(object sender, EventArgs e)
    {
        var q = from c in
                    System.Globalization.CultureInfo.GetCultures
                    (System.Globalization.CultureTypes.AllCultures)
                orderby c.EnglishName
                orderby c.TwoLetterISOLanguageName
                group c by c.TwoLetterISOLanguageName
                    into g
                    select new
                    {
                        ISO = g.Key,
                        culture = g.Distinct()
                    };

        dlLetters.DataSource = q;
        dlLetters.DataBind();
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Languages</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:DataList ID="dlLetters" runat="server">
            <ItemTemplate>
                <asp:Label ID="lblISO" runat="server" Text='<%# Eval("ISO") %>'>
                </asp:Label><br />
                <asp:DataList ID="DataList1" runat="server" DataSource='<%# Eval("culture") %>'>
                    <ItemTemplate>
                        -<asp:Label ID="lblName" runat="server" Text='<%# Eval("EnglishName") %>'><br />
                        </asp:Label><br />
                    </ItemTemplate>
                </asp:DataList>
            </ItemTemplate>
        </asp:DataList>
    </div>
    </form>
</body>
</html>
