﻿<%@ WebService Language="C#" Class="rgbservice" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://kencox.ca/", Name="Ken's RGB Service",Description="Returns RGB values for a known colour")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class rgbservice  : System.Web.Services.WebService {

    [WebMethod]
    public string GetRGB(string strKnownColor) 
    
    {
        System.Threading.Thread.Sleep(4000);
        System.Drawing.Color colr;
        System.Text.RegularExpressions.Regex rgx = new System.Text.RegularExpressions.Regex("^[a-zA-Z]{1,30}$");
        if (! rgx.IsMatch(strKnownColor))
        {
         return "Bad input";   
        }
        colr = System.Drawing.Color.FromName(strKnownColor);
        if (colr.R == 0 && colr.G == 0 && colr.B == 0 && strKnownColor.ToUpper() != "BLACK")
        {
            return "Not known";
        }
        else
        {
            return (colr.R.ToString() + ":" + colr.G.ToString() + ":" + colr.B.ToString());
        }
     
    }
    
}

