﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Linq" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            var q = from tz in TimeZoneInfo.GetSystemTimeZones()
                    where tz.SupportsDaylightSavingTime == true
                    orderby tz.StandardName
                    select new { sname = tz.StandardName, dname = tz.DaylightName };
            DropDownList1.DataSource = q;
            DropDownList1.DataTextField = "dname";
            DropDownList1.DataValueField = "sname";
            DropDownList1.DataBind();
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        ServiceReference1.ServiceClient srvc = new ServiceReference1.ServiceClient();
        string tzone = DropDownList1.SelectedValue;
        Label1.Text = Regex.Replace(srvc.GetTimeZoneInfo(tzone), Environment.NewLine, "<br />");
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:DropDownList ID="DropDownList1" runat="server">
        </asp:DropDownList>
        <br />
        <br />
        <asp:Button ID="Button1" runat="server" Text="Button" OnClick="Button1_Click" />
        <br />
        <br />
        <asp:Label ID="Label1" runat="server"></asp:Label>
    </div>
    </form>
</body>
</html>
