﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;

// NOTE: If you change the class name "Service" here, you must also update the reference to "Service" in Web.config.
public class Service : IService
{
    public string GetTimeZoneInfo(string strLocalTimeZone)
    {
        StringBuilder sb = new StringBuilder();
        TimeZoneInfo tst;
        try
        {
            tst = TimeZoneInfo.FindSystemTimeZoneById(strLocalTimeZone);
        }
        catch (TimeZoneNotFoundException exc)
        {
            return "Can't find the time zone " + strLocalTimeZone + ".";
        }
        catch (Exception exc)
        {
            return exc.Message;
        }

         foreach (TimeZoneInfo.AdjustmentRule tzadj in tst.GetAdjustmentRules())
        {
            sb.Append("Daylight time starts: " + CTT(tzadj.DaylightTransitionStart) + Environment.NewLine);
            sb.Append("Standard time returns: " + CTT(tzadj.DaylightTransitionEnd) + Environment.NewLine);
            sb.Append(Environment.NewLine);
        }
        return sb.ToString();
    }

    public string CTT(TimeZoneInfo.TransitionTime tr)
    {
        string[] nums = { "first", "second", "third", "fourth", "final" };
        StringBuilder sb = new StringBuilder();
        if (tr.IsFixedDateRule)
        {
            sb.Append(tr.DayOfWeek.ToString());
        }
        else
        { 
        sb.Append("The " + nums[tr.Week - 1] + " " + tr.DayOfWeek + " of");
        }

        return sb.Append(" " + System.Globalization.DateTimeFormatInfo.GetInstance(null).GetMonthName(tr.Month)).ToString();

    }

    public void DoWork()
    {
    }
}
